// $Id: CWindowAttributes.cpp,v 1.6 2007/02/08 21:07:54 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CWindowAttributes.hpp"
using Exponent::GUI::Windowing::CWindowAttributes;	

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CWindowAttributes, CCountedObject);

//	===========================================================================
CWindowAttributes::CWindowAttributes() 
				 : m_alpha(1.0)
				 , m_windowIcon(NULL)
				 , m_enabled(true)
				 , m_hasShadow(false)
#ifdef WIN32
				 , m_windowStyle(0)
				 , m_windowStyleEx(0)		
#else
				 , m_windowStyle(0)
				 , m_windowClass(0)	
#endif
{
	NULL_POINTER(m_windowIcon);
	this->setWindowAttributes("Application", CColour::CCOLOUR_BLACK, 1.0, NULL, true, false);
#ifdef WIN32
	this->initialise(WS_OVERLAPPEDWINDOW | CS_DBLCLKS, WS_EX_ACCEPTFILES);
#else
	this->initialise(kWindowStandardDocumentAttributes | kWindowStandardHandlerAttribute, kDocumentWindowClass);
#endif
	EXPONENT_CLASS_CONSTRUCTION(CWindowAttributes);
}

//	===========================================================================
CWindowAttributes::~CWindowAttributes()
{
	EXPONENT_CLASS_DESTRUCTION(CWindowAttributes);
	FORGET_COUNTED_OBJECT(m_windowIcon);
}

//	===========================================================================
CWindowAttributes &CWindowAttributes::operator = (const CWindowAttributes &attributes)
{
	// Check if they are the same
	if (&attributes != this)
	{
		// Initialise platform specific
#ifdef WIN32
		this->initialise(attributes.m_windowStyle, attributes.m_windowStyleEx);
#else
		this->initialise(attributes.m_windowStyle, attributes.m_windowClass);
#endif
		// STore the other attributes
		this->setWindowAttributes(attributes.m_title, attributes.m_backgroundColour, attributes.m_alpha, attributes.m_windowIcon, attributes.m_enabled, attributes.m_hasShadow);
	}

	// REturn the instance of this
	return *this;
}

//	===========================================================================
void CWindowAttributes::initialise(const EWindowStyle style)
{
	switch(style)
	{
		case e_default:
			#ifdef WIN32
				this->initialise(WS_OVERLAPPEDWINDOW | CS_DBLCLKS, WS_EX_ACCEPTFILES);
			#else
				this->initialise(kWindowStandardDocumentAttributes | kWindowStandardHandlerAttribute, kDocumentWindowClass);
			#endif
		break;
		case e_noMaximiseNoSize:
			#ifdef WIN32
				this->initialise(WS_OVERLAPPED | WS_CAPTION | WS_MINIMIZEBOX | WS_SYSMENU, WS_EX_ACCEPTFILES);
			#else
				this->initialise(kWindowCloseBoxAttribute | kWindowCollapseBoxAttribute | kWindowStandardHandlerAttribute, kDocumentWindowClass);
			#endif
		break;
		case e_noMaximiseNoSizeNoClose:
			#ifdef WIN32
				this->initialise(WS_OVERLAPPED | WS_CAPTION | WS_MINIMIZEBOX | WS_SYSMENU, WS_EX_ACCEPTFILES);
			#else
				this->initialise(kWindowCollapseBoxAttribute | kWindowStandardHandlerAttribute, kDocumentWindowClass);
			#endif
		break;
	}
}

//	===========================================================================
#ifdef WIN32
void CWindowAttributes::initialise(const long style, const long styleEx)
{
	m_windowStyle   = style;
	m_windowStyleEx = styleEx;
}	
#else
void CWindowAttributes::initialise(WindowAttributes style, WindowClass windowClass)
{
	m_windowStyle = style;
	m_windowClass = windowClass;
}	
#endif

//	===========================================================================
void CWindowAttributes::setWindowAttributes(const CString &title, const CColour &backgroundColour, const double alpha, CWindowIcon *windowIcon, const bool enabled, const bool shadow)
{
	this->setWindowTitle(title);
	this->setBackgroundColour(backgroundColour);
	this->setWindowAlphaValue(alpha);
	this->setWindowEnabled(enabled);
	this->windowHasShadow(shadow);
	this->setWindowIcon(windowIcon);
}

//	===========================================================================
void CWindowAttributes::setWindowIcon(CWindowIcon *icon) 
{ 
	EXCHANGE_COUNTED_OBJECTS(m_windowIcon, icon);
}